	.6502
	.list

*
* DUNGEON KERNAL SEVEN PROGRAM
*
* WRITTEN BY ADAM CLAYTON
*
*
* 
*
*
* EQUATES
*
VSYNC	=	$00
VBLANK	=	$01
WSYNC	=	$02
RSYNC	=	$03
NUSIZ0	=	$04
NUSIZ1	=	$05
COLUP0	=	$06
COLUP1	=	$07
COLUPF	=	$08
COLUBK	=	$09
CTRLPF	=	$0A
REFP0	=	$0B
REFP1	=	$0C
PF0	=	$0D
PF1	=	$0E
PF2	=	$0F
RESP0	=	$10
RESP1	=	$11
RESM0	=	$12
RESM1	=	$13
RESBL	=	$14
AUDC0	=	$15
AUDC1	=	$16
AUDF0	=	$17
AUDF1	=	$18
AUDV0	=	$19
AUDV1	=	$1A
GRP0	=	$1B
GRP1	=	$1C
ENABL	=	$1F
HMP0	=	$20
HMP1	=	$21
HMBL	=	$24
HMOVE	=	$2A
HMCLR	=	$2B
SWCHA	=	$280
	.ORG	$80
ADPF0:	.DS.B	2	;ADDRESS OF PLAYFIELD (ADDR),Y
ADPF1:	.DS.B	2
ADPF2:	.DS.B	2
COLOR:	.DS.B	2
VERTP0: .DS.B	8	;VERTICAL OFFSET PLAYER
VERTP1: .DS.B	8
HORIP0: .DS.B	8	;HORIZONTAL LOCATIONS
HORIP1: .DS.B	8
PLREF0: .DS.B	8	;PLAYER REFLECT AND SIZE
PLREF1: .DS.B	8
PTYPE0: .DS.B	8	;PLAYER TYPE
PTYPE1: .DS.B	8
LTYPE:	.DS.B	8	;LINE TYPE 0=P1 RESET 1=P0 RESET FF=BOTH
ADDRP0: .DS.B	2	;ADDRESS OF PLAYER 0
ADDRP1: .DS.B	2
VOFFP0: .DS.B	1	;VERTICAL OFFSET PLAYER 0
VOFFP1: .DS.B	1
COLP0:	.DS.B	2	;COLOR ADDRESS
COLP1:	.DS.B	2
WIDP0:	.DS.B	1	;LENGTH OF PLAYERS COUNTER
WIDP1:	.DS.B	1
TEMP:	.DS.B	5	;TEMPARARY LOCATIONS
PCOUNT: .DS.B	1	;PLAYER RESET COUNTER
PFCOUNT:	.DS.B	1	;PLAYFIELD UPDATE COUNTER
COUNTER:	.DS.B	1	;LINE COUNTER
VCOUNT: .DS.B	1	;LINES TILL PLAYFIELD DRAW
V1COUNT:	.DS.B	1	;LINES TILL PLAYER RESET
XPOS0:	.DS.B	1
CURRENT:	.DS.B	1
C:	.DS.B	1
C1:	.DS.B	1
C2:	.DS.B	1
NEWDIR: .DS.B	1
NEWX:	.DS.B	1
NEWX1:	.DS.B	1
NEWY:	.DS.B	1
NEWY1:	.DS.B	1
FIRE:	.DS.B	2
VTEMP	=	VERTP0
DI	=	VERTP0
KE	=	VERTP1
	.ORG	$F000
main:
	lda #$fd ;#$2	;put unit into 2600 mode
	sta $08  ;$1
	sei
	cld
	ldy #00
MA:
	nop			;wait loop
	nop
	nop
	nop
	dey
	bne MA
	ldx	#$ff	;init stack
	txs

	ldx #0		;turn off vertical blank
	STX	$3
	stx 1
	LDA	#1
	STA	CTRLPF
	LDA	#159
	STA	XPOS0
	STX	$1D
	STX	$1E
	STX	$1F
	STX	LEVEL
	STX	SOUND0
	STX	SOUND0+1
	STX	C
	STX	FIRE
	STX	FIRE+1
	STX	FRMCNT
	LDX	#7
	LDA	#$0C
	STA	NEWDIR
	LDA	#$01
	STA	C1
	STA	C2
SKIP4:
	LDA	STARTAB,X
	STA	ADPF0,X
	DEX
	BPL	SKIP4

M0:
	lda	#$42
	ldy	#0
	sta	2	    ;wait
	sta	0	    ;start vertical sync
	JSR	AUDIO
	sta	2
	STY	NUSIZ0
	STY	NUSIZ1
	STY	ENABL
	sta	2	    ;wait 3 lines
	LDA	$282
	AND	#$01
	BNE	.1
	LDA	#$3F
	STA	HEALTH
	STA	HEALTH+1
	LDA	#$00
	STA	SCORLO
	STA	SCORLO+1
	STA	SCORHI
	STA	SCORHI+1
	STA	ENEMHOR
	TAX
	JSR	STLEVEL
.1:
	LDA	#$42
	LDY	#$00
	sta	2
	sty	0	    ;turn off vertical sync
	sta	1	    ;turn on vertical blank
	LDA	COLOR+1
	STA	$9
	LDA	COLOR
	STA	$8
	LDA	#$01
	STA	CTRLPF
	LDA	#41
	STA	$296	;START TIMER
SKIP1:
	JMP	UPLAY
SKIP3:
	LDA	#3
	STA	COUNTER
	LDA	#$4
	STA	VCOUNT
	LDA	#5
	STA	V1COUNT
	LDA	C
	LSR
	LSR
	STA	PFCOUNT
	LDY	#$00
	STY	PCOUNT
	LDA	C
	EOR	#$0F
	AND	#$0F
	STA	WIDP0
	STA	WIDP1
	STA	WSYNC
	JMP	MKERNAL
NORMAL1:
.5:	LDA	$284
	BNE	.5
	STA	WSYNC
	LDA	#$00
	STA	VBLANK
	STA	HMCLR
	LDA	V1COUNT
	BEQ	.6
	JMP	MLOOP
.6:	JMP	MKERP0
NORMAL:
	LDA	C
	EOR	#$0F
	AND	#$0F
	STA	V1COUNT
	LDA	C
	AND	#$03
	TAX
	LDA	LTAB,X
	STA	VCOUNT
	LDA	V1COUNT
	STA	WIDP0
	STA	WIDP1
	LDA	#70
	STA	COUNTER
	JMP	NORMAL1
	.ORG	$F100
*
* KERNAL PROGRAM TO DO P1 RESET AND CARRY P0 THROUGH
*
MKERP1:
	BPL	.0
	JMP	MKERNAL
.0:
	LDA	VOFFP0
	BNE	.3
	LDY	WIDP0
	DEY
	STY	WIDP0
	BMI	.4
	LDA	(ADDRP0),Y
	STA	TEMP
	LDA	(COLP0),Y
.1:	STA	TEMP+1
	LDA	VOFFP0
	BNE	.5
	LDY	WIDP0
	DEY
	STY	WIDP0
	BMI	.6
	LDA	(ADDRP0),Y
	STA	TEMP+2
	LDA	(COLP0),Y
.2:	STA	TEMP+3
	LDY	PCOUNT
	STA	HMCLR
	LDA	HORIP1,Y
	STA	HMP1
	AND	#$0F
	LSR
	TAX
	STA	WSYNC
	LDA	#$00
	STA	GRP1
	LDA	TEMP
	STA	GRP0
	LDA	TEMP+1
	STA	COLUP0
	LDA	PLREF1,Y
	STA	REFP1
	STX	TEMP
	DEC	COUNTER
	BEQ	.8
	LDY	PFCOUNT
	LDA	(ADPF2),Y
	STA	TEMP+1
	LDA	(ADPF1),Y
	TAX
	LDA	(ADPF0),Y
	LDY	TEMP+1
	JMP	.9
.3:
	DEC	VOFFP0		;IF NOT READY DEC COUNTER AND CLEAR P0 VALUES
	LDA	#$00
	STA	TEMP
	JMP	.1	
.4:
	LDA	#$00			;IF ALREADY DONE THEN CLEAR COUNTER, 
	STA	TEMP
	STA	WIDP0
	JMP	.1			;
.5:
	DEC	VOFFP0		;IF NOT READY DEC COUNTER AND CLEAR P1 VALUES
	LDA	#$00
	STA	TEMP+2
	JMP	.2			;
.6:
	LDA	#$00			;IF ALREADY DONE THEN CLEAR COUNTER, 
	STA	TEMP+2
	STA	WIDP0
	JMP	.2			;
.7:
	DEX
	BNE	.7
	STA	RESP1
	LDY	PCOUNT
	LDA	VERTP1,Y
	STA	VOFFP1
	LDA	#14
	STA	WIDP1
	INC	PFCOUNT
	LDY	TEMP+3
	LDA	TEMP+2
	JMP	.11
.8:
	JMP	SDONE

.9:	STA	WSYNC
	STA	PF0
	STX	PF1
	STY	PF2
	LDX	TEMP
	BCS	.7
	LDY	PCOUNT
	LDA	VERTP1,Y
	STA	VOFFP1
	LDA	#14
	STA	WIDP1
	INC	PFCOUNT
	LDY	TEMP+3
	LDA	TEMP+2
.10:	DEX
	BNE	.10
	STA	RESP1
.11:	STA	WSYNC
	STA	GRP0
	STY	COLUP0
	DEC	COUNTER
	BEQ	.8
	LDY	PCOUNT
	LDX	PTYPE1,Y
	LDY	PDATA,X
	LDA	PTYPEHI,Y
	STA	ADDRP1+1
	LDA	PTYPELO,Y
	STA	ADDRP1
	LDY	PCOLOR,X
	LDA	COHI,Y
	STA	COLP1+1
	LDA	COLO,Y
	STA	COLP1
	INC	PCOUNT
	JMP	MKEREND
	
	.ORG	$F200
*
* KERNAL PROGRAM TO DO P0 RESET AND CARRY P1 THROUGH
*
MKERP0:
	LDY	PCOUNT
	LDA	LTYPE,Y
	BEQ	.A
	JMP	MKERP1
.A:
	LDA	VOFFP1
	BNE	.3
	LDY	WIDP1
	DEY
	STY	WIDP1
	BMI	.4
	LDA	(ADDRP1),Y
	STA	TEMP
	LDA	(COLP1),Y
.1:	STA	TEMP+1
	LDA	VOFFP1
	BNE	.5
	LDY	WIDP1
	DEY
	STY	WIDP1
	BMI	.6
	LDA	(ADDRP1),Y
	STA	TEMP+2
	LDA	(COLP1),Y
.2:	STA	TEMP+3
	STA	HMCLR
	LDY	PCOUNT
	LDA	HORIP0,Y
	STA	HMP0
	AND	#$0F
	LSR
	TAX
	STA	WSYNC
	LDA	#$00
	STA	GRP0
	LDA	TEMP
	STA	GRP1
	LDA	TEMP+1
	STA	COLUP1
	LDA	PLREF0,Y
	STA	REFP0
	STX	TEMP
	DEC	COUNTER
	BEQ	.8 
	LDY	PFCOUNT
	LDA	(ADPF2),Y
	STA	TEMP+1
	LDA	(ADPF1),Y
	TAX
	LDA	(ADPF0),Y
	LDY	TEMP+1
	JMP	.9
.3:
	DEC	VOFFP1		;IF NOT READY DEC COUNTER AND CLEAR P0 VALUES
	LDA	#$00
	STA	TEMP
	JMP	.1	
.4:
	LDA	#$00			;IF ALREADY DONE THEN CLEAR COUNTER, 
	STA	TEMP
	STA	WIDP1
	JMP	.1			;
.5:
	DEC	VOFFP1		;IF NOT READY DEC COUNTER AND CLEAR P1 VALUES
	LDA	#$00
	STA	TEMP+2
	JMP	.2			;
.6:
	LDA	#$00			;IF ALREADY DONE THEN CLEAR COUNTER, 
	STA	TEMP+2
	STA	WIDP1
	JMP	.2			;
.7:
	DEX
	BNE	.7
	STA	RESP0
	LDY	PCOUNT
	LDA	VERTP0,Y
	STA	VOFFP0
	LDA	#14
	STA	WIDP0
	INC	PFCOUNT
	LDY	TEMP+3
	LDA	TEMP+2
	JMP	.11
.8:
	JMP	SDONE

.9:	STA	WSYNC
	STA	PF0
	STX	PF1
	STY	PF2
	LDX	TEMP
	BCS	.7
	LDY	PCOUNT
	LDA	VERTP0,Y
	STA	VOFFP0
	LDA	#14
	STA	WIDP0
	INC	PFCOUNT
	LDY	TEMP+3
	LDA	TEMP+2
.10:	DEX
	BNE	.10
	STA	RESP0
.11:	STA	WSYNC
	STA	GRP1
	STY	COLUP1
	DEC	COUNTER
	BEQ	.8
	LDY	PCOUNT
	LDX	PTYPE0,Y
	LDY	PDATA,X
	LDA	PTYPEHI,Y
	STA	ADDRP0+1
	LDA	PTYPELO,Y
	STA	ADDRP0
	LDY	PCOLOR,X
	LDA	COHI,Y
	STA	COLP0+1
	LDA	COLO,Y
	STA	COLP0
	INC	PCOUNT
	JMP	MKEREND

	.ORG	$F300
*
* KERNAL PROGRAM TO CHECK AND DO BOTH PLAYER RESETS
*
MKERNAL:
	LDA	HORIP1,Y
	STA	HMP1
	AND	#$0F
	STA	TEMP+1
	LDX	PTYPE0,Y
	LDY	PDATA,X
	LDA	PTYPEHI,Y
	STA	ADDRP0+1
	LDA	PTYPELO,Y
	STA	ADDRP0
	LDY	PCOLOR,X
	LDA	COHI,Y
	STA	COLP0+1
	LDA	COLO,Y
	STA	COLP0
	LDY	PCOUNT
	LDX	PTYPE1,Y
	LDY	PDATA,X
	LDA	PTYPEHI,Y
	STA	ADDRP1+1
	LDA	PTYPELO,Y
	STA	ADDRP1
	LDY	PCOLOR,X
	LDA	COHI,Y
	STA	COLP1+1
	LDA	COLO,Y
	STA	COLP1
	LDA	#$00
	STA	GRP0
	STA	GRP1
	LDY	PCOUNT
	LDA	HORIP0,Y
	STA	HMP0
	AND	#$0F
	LSR
	STA	TEMP
	LDA	PLREF0,Y
	STA	REFP0
	LDA	PLREF1,Y
	STA	REFP1
	DEC	COUNTER
	BEQ	.1
	LDY	PFCOUNT
	LDA	(ADPF1),Y
	TAX
	LDA	(ADPF2),Y
	STA	TEMP+2
	LDA	(ADPF0),Y
	LDY	TEMP+2
	JMP	.3
.1:
	JMP	SDONE
.ORG	$F400
.2:	DEX
	BNE	.2
	STA	RESP0
	LDY	PCOUNT
	LDA	VERTP0,Y
	STA	VOFFP0
	LDA	#14
	STA	WIDP0
	STA	WIDP1
	JMP	.5
.3:	STA	WSYNC
	STA	PF0
	STX	PF1
	STY	PF2
	LDX	TEMP
	BCS	.2
	LDY	PCOUNT
	LDA	VERTP0,Y
	STA	VOFFP0
	LDA	#14
	STA	WIDP0
	STA	WIDP1
	NOP
	NOP
	NOP
	NOP
.4:	DEX
	BNE	.4
	STA	RESP0
.5:	STA	WSYNC
	DEC	COUNTER
	BNE	.17
	JMP	SDONE
.17:
	LDA	TEMP+1
	LSR
	BCC	.7
.6:	SBC	#$01
	BNE	.6
	STA	RESP1
	LDY	PCOUNT
	LDA	VERTP1,Y
	STA	VOFFP1
	INC	PFCOUNT
	INC	PCOUNT
	JMP	.9
.7:	TAX
	LDY	PCOUNT
	LDA	VERTP1,Y
	STA	VOFFP1
	INC	PFCOUNT
	INC	PCOUNT
	NOP
.8:	DEX
	BNE	.8
	STA	RESP1
.9:
MKEREND:
	STA	WSYNC
	STA	HMOVE
	LDA	COLOR
	STA	COLUPF
	LDA	VOFFP0
	BNE	.12
	LDY	WIDP0
	DEY
	STY	WIDP0
	BMI	.13
	LDA	(ADDRP0),Y
	STA	TEMP
	LDA	(COLP0),Y
.10:	STA	TEMP+1
	LDA	VOFFP1
	BNE	.14
	LDY	WIDP1
	DEY
	STY	WIDP1
	BMI	.15
	LDA	(ADDRP1),Y
	TAX
	LDA	(COLP1),Y
.11:	LDY	#$03
	STY	VCOUNT
	STA	WSYNC
	STA	COLUP1
	STX	GRP1
	LDA	TEMP
	STA	GRP0
	LDA	TEMP+1
	STA	COLUP0
	LDA	#13
	STA	V1COUNT
	DEC	COUNTER
	BEQ	.16
	JMP	MLOOP
.16:
	JMP	SDONE

.12:	DEC	VOFFP0		;IF NOT READY DEC COUNTER AND CLEAR P0 VALUES
	LDA	#$00
	STA	TEMP
	JMP	.10
.13:	LDA	#$00		;21 IF ALREADY DONE THEN CLEAR COUNTER,
	STA	TEMP
	STA	WIDP0
	JMP	.10		;30

.14:	DEC	VOFFP1		;53 IF NOT READY DEC COUNTER AND CLEAR P1 VALUES
	LDA	#$00
	TAX
	JMP	.11			;60

.15:	LDA	#$00			;61 IF ALREADY DONE THEN CLEAR COUNTER, 
	TAX
	STA	WIDP1
	JMP	.11			;69
*
* MAIN KERNAL LOOP
* DOES PLAYERS AND PLAYFIELD IF NEEDED
* ALSO CHECKS FOR END OF SCREEN AND NEXT RESET
*
*  LOCATIONS USED:
*  PLAYER INFORMATION
*	VOFFP0	
*	VOFFP1
*	WIDP0
*	WIDP1
*	ADDRP0
*	ADDRP1
*	COLP0
*	COLP1
*  PLAYFIELD INFORMATION
*	ADPF0
*	ADPF1
*	ADPF2
*	PFCOUNT
*	VCOUNT
*  MAIN LINE COUNTER
*	COUNTER
*  RESET LINE COUNTER
*	V1COUNT
*  TEMPARARY LOCATIONS
*	TEMP
*
	.ORG	$F500
MLOOP:
	LDA	VOFFP0		;36 CHECK OFFSET COUNTER FOR PLAYER 0
	BNE	.4			;38
	LDY	WIDP0		;41 CHECK WIDTH NUMBER IF DONE
	DEY
	STY	WIDP0		;46
	BMI	.5
	LDA	(ADDRP0),Y	;53
	STA	TEMP
	LDA	(COLP0),Y		;61
.1:	STA	TEMP+1
	DEC	VCOUNT		;69 DEC PF COUNTER FOR DOING PLAYFIELD
	STA	WSYNC		;NEXT LINE
	BNE	.2			;2 IF TURN TO DO PLAYFIELD DO SO
	LDY	PFCOUNT
	LDA	(ADPF0),Y		;10 GET PLAYFIELD DATA IN REGISTERS
	STA	PF0			;13
	STA	ENABL		;16
	LDA	(ADPF1),Y
	STA	PF1			;24
	LDA	(ADPF2),Y
	STA	PF2			;32
	INC	PFCOUNT 	;37 INCREMENT PF COUNTER
	LDA	#$04			;39
	STA	VCOUNT		;42 INITIALIZE LINES TILL PF
.2:	LDA	VOFFP1		;45 CHECK OFFSET FOR PLAYER 1
	BNE	.6
	LDY	WIDP1		;50
	DEY
	STY	WIDP1		;55
	BMI	.7
	LDA	(ADDRP1),Y	;62
	TAX
	LDA	(COLP1),Y		;69
.3:	STA	WSYNC
	STA	COLUP1
	STX	GRP1
	LDA	TEMP			;9 UPDATE PLAYER GRAPHICS, COLORS
	STA	GRP0
	LDA	TEMP+1
	STA	COLUP0
	DEC	COUNTER 	;23 CHECK IF AT END OF SCREEN
	BEQ	.8
	DEC	V1COUNT 	;30 CHECK IF NEW RESET LINE
	BNE	MLOOP		;33
	JMP	MKERP0		;35 JUMP TO OTHER RESET PROGRAM
.4:	DEC	VOFFP0		;IF NOT READY DEC COUNTER AND CLEAR P0 VALUES
	LDA	#$00
	STA	TEMP
	JMP	.1
	
.5:	LDA	#$00			;21 IF ALREADY DONE THEN CLEAR COUNTER, 
	STA	TEMP
	STA	WIDP0
	JMP	.1			;30

.6:	DEC	VOFFP1		;53 IF NOT READY DEC COUNTER AND CLEAR P1 VALUES
	LDA	#$00
	TAX
	JMP	.3			;60

.7:	LDA	#$00			;61 IF ALREADY DONE THEN CLEAR COUNTER, 
	TAX
	STA	WIDP1
	JMP	.3			;69

.8:
SDONE:
	LDA	PCOUNT
	CMP	#$01
	BEQ	P11
	JMP	SCORE
PFDONE:
	LDA	#00
	STA	WSYNC
	STA	COLUP0
	STA	COLUPF
	STA	COLUP1
	STA	COLUBK
	LDA	#70
	STA	$296
	LDA	C2
	CMP	#$00
	BNE	.1
	JSR	UPGUYS
	JSR	SETPLAY
	LDA	#$01
	STA	C2
	JMP	.10
.1:
	CMP	#$01
	BNE	.2
	JSR	UPJOY
	LDA	#$02
	STA	C2
	JMP	.10
.2:
	JSR	ENEMYUP
	LDA	#$00
	STA	C2
.10:
	LDA	$284
	BNE	.10
	STA	WSYNC
	JMP	M0
P11:	JMP	NORMAL
*
* WILL WRITE TO THE KERNAL REGISTERS CONCERNING THE PLAYERS TO BE
* DRAWN THIS TURN
* 
* MEMORY LOCATIONS USED:
* TEMP	LINE COUNTER
* TEMP+1	MAX NUMBER OF PLAYERS ON LINE TO ADD TO CURRENT
* CURRENT	COUNTER TO PLAYER IN PLAYTAB
* 
UPLAY:
	LDX	#$00
	LDA	#$FF
	STX	TEMP
	STA	LTYPE,X ;FIRST LINE = FF (BOTH RESET)
	STX	CURRENT
	JMP	.3
.1:
	LDA	LTYPE,X ;CHECK TYPE OF LINE
	BMI	.3
	BNE	.2
	LDA	#$00		;P0 RESET PORTION
	JSR	GETPLAY ;LOAD P0 INFORMATION
	BMI	.6		;IF NO REQUEST THEN DONE
	LDA	#$01		;IF REQUEST THEN P1 RESET
	BNE	.6
.2:
	LDA	#$08		;P1 RESET PORTION
	JSR	GETPLAY ;LOAD P1 INFORMATION
	BMI	.6
	LDA	#$00		;IF REQUEST THEN P0 RESET
	BEQ	.6
.3:
	LDA	#$08		;BOTH RESET PORTION
	JSR	GETPLAY ;LOAD P1 INFORMATION
	STA	TEMP+4	;STORE REQUEST INFORMATION
	LDA	#$00		;GET P0 INFORMATION
	JSR	GETPLAY
	BPL	.4		;IF REQUEST SKIP
	LDA	TEMP+4	;IF P0=NO P1=NO THEN X IS OK
	BMI	.6
	LDA	#$00		;IF P0=NO P1=YES THEN P0 RESET
	BEQ	.6
.4:
	LDA	TEMP+4	;IF P0=YES P1=YES THEN SKIP
	BPL	.5
	LDA	#$01		;IF P0=YES P1=NO THEN P1 RESET
	BNE	.6
.5:
	LDA	#$80		;IF BOTH REQUEST THEN CLEAR OUT P0 VOFFSET
	STA	VERTP0,Y
	DEC	LINE1TAB,X	;DECREMENT CURRENT PLAYER COUNTER
	LDA	#$00		;SET FOR P0 RESET
.6:
	INX			;A= NEXT LINE'S INFORMATION
	CPX	#$06		;INCREMENT LINE COUNTER
	BEQ	.7		;IF = 0 THEN EXIT
	STX	TEMP
	STA	LTYPE,X ;STORE INFORMATION ON NEXT LINE
	LDA	TEMP+1
	CLC
	ADC	CURRENT ;ADD NUMBER OF PLAYERS IN LINE TO COUNTER
	STA	CURRENT
	BCC	.1		;LOOP BACK
.7:
	JMP	SKIP3
*
* GET PLAYER INFORMATION USING PLAYTAB AND CURRENT LINE
* ON ENTRY
*  A = PLAYER 0=PLAYER0 8=PLAYER1
*  X = TEMP = LINE NUMBER
* ON EXIT
*  A = PLAYTAB BIT 7 0=REQUEST 1=NO REQUEST
*  Y = PLAYER OFFSET  PLAYER+LINE#
*  X = TEMP (LINE COUNTER)
*
* LOCATIONS USED:
* TEMP	LINE COUNTER (REFERENCE)
* TEMP+1	NUMBER OF PLAYERS ON LINE
* TEMP+2	PLAYTAB INFORMATION
* TEMP+3	OFFSET TO PLAYER IN KERNAL
* COUNTER	USED TO OBTAIN ADDRESS OF PLAYER IN PLAYTAB
*
GETPLAY:
	CLC
	ADC	TEMP		;CALC OFFSET IN KERNAL LOCATIONS
	STA	TEMP+3		;TEMP+3 = LINE+PLAYER
	LDA	LINETAB,X	;GET NUMBER OF PLAYERS IN LINE
	STA	TEMP+1
	BNE	.1
	LDY	TEMP+3		;ALSO CLEAR OUT PLAYER
	LDA	#$33
	STA	HORIP0,Y
	LDA	#$80
	STA	VERTP0,Y	;RETURN WITH SIGN BIT SET AND Y = OFFSET
	RTS
.1:
	LDA	LINE1TAB,X	;GET CURRENT VALUE
	CMP	TEMP+1		;CHECK AGAINST MAX VALUE
	BNE	.2
	LDA	#$00		;IF CURRENT = MAX THEN CURRENT = 0
.2:
	CLC
	STA	LINE1TAB,X	;STORE IN TABLE
	ADC	CURRENT 	;ADD TO OFFSET IN PLAYTAB
	TAX
	LDA	PLAYTAB,X	;LOAD PLAYER INFORMATION
	STA	TEMP+2		;STORE AWAY
	AND	#$0F
	TAY
	LDX	ENEMHOR,Y
	LDA	HTAB,X
	LDX	TEMP+3
	STA	HORIP0,X
	LDA	ENEMTYP,Y
	STA	PTYPE0,X
	LDA	ENEMREF,Y
	STA	PLREF0,X
	LDA	ENEMVER,Y
	AND	#$0F
	STA	VERTP0,X
	BNE	.25
	LDA	#$FF
	BMI	.27
.25:
	LDA	#$00
.27:
	STA	TEMP+2
	LDX	TEMP
	INC	LINE1TAB,X
	LDY	TEMP+3
	LDA	TEMP+2
.7:
	RTS
*
* PROGRAM TO SET UP PLAYTAB
*
SETPLAY:
	LDA	C
	AND	#$F0
	STA	TEMP+1
	LDA	#$00
	STA	TEMP
	STA	TEMP+2
.1:
	LDA	#$00
	STA	TEMP+3
	LDX	#$0F
.2:
	LDA	ENEMVER,X
	CMP	#$FF
	BEQ	.3
	AND	#$F0
	CMP	TEMP+1
	BEQ	.5
.3:
	DEX
	BPL	.2
	LDA	TEMP+1
	CLC
	ADC	#$10
	STA	TEMP+1
	LDX	TEMP
	LDA	TEMP+3
	STA	LINETAB,X
	CMP	LINE1TAB,X
	BCS	.4
	STA	LINE1TAB,X
.4:
	INX
	STX	TEMP
	CPX	#$06
	BNE	.1
	RTS
.5:
	LDY	TEMP+2
	TXA
	STA	PLAYTAB,Y
	INC	TEMP+2
	INC	TEMP+3
	BNE	.3
*
* UPDATE JOYSTICKS
*
UPJOY:
	LDX	C1
	DEX
	BPL	.1
	LDX	#$07
.1:
	STX	C1
	LDA	SWCHA
	TAX
	LDY	ENEMVER+1
	CPY	#$FF
	BNE	.11
	LDA	#$00
	STA	DIR+1
	LDA	#$80
	STA	ENEMTYP+1
	BNE	.21
.11:
	AND	#$0F
	TAY
	LDA	DIRJOY,Y
	BNE	.2
	LDA	DIR+1
	AND	#$14
.2:
	STA	DIR+1
.21:
	LDA	ENEMVER
	CMP	#$FF
	BNE	.25
	LDA	#$00
	STA	DIR
	LDA	#$80
	STA	ENEMTYP
	BNE	.31
.25:
	TXA
	LSR
	LSR
	LSR
	LSR
	TAY
	LDA	DIRJOY,Y
	BNE	.3
	LDA	DIR
	AND	#$14
.3:
	STA	DIR
.31:
	LDA	ENEMVER
	CMP	#$FF
	BEQ	.4
	LDX	#0
	JSR	CKPF
	JSR	CKGUYS
	LDX	#$00
	JSR	CKOBJECT
	JSR	UPXY
	LDX	#0
	JSR	ANIMATE
	LDX	#0
	JSR	STLEVEL
	LDX	#0
	JSR	FARROW
.4:
	LDA	ENEMVER+1
	CMP	#$FF
	BEQ	.5
	LDX	#1
	JSR	CKPF
	JSR	CKGUYS
	LDX	#$01
	JSR	CKOBJECT
	JSR	UPXY
	LDX	#1
	JSR	ANIMATE
	LDX	#$01
	JSR	STLEVEL
	LDX	#1
	JSR	FARROW
.5:
	JSR	CHKIT
	RTS
CHKIT:
	LDA	ENEMVER
	CMP	#$FF
	BEQ	.1
	LDA	ENEMVER+1
	CMP	#$FF
	BEQ	.0
	LDA	SCORHI
	CMP	SCORHI+1
	BEQ	.2
	BCC	.1
.0:
	LDA	#$00
	BEQ	.4
.1:
	LDA	#$01
	BNE	.4
.2:
	LDA	SCORLO
	CMP	SCORLO+1
	BEQ	.5
	BCC	.3
	LDA	#$00
	BEQ	.4
.3:
	LDA	#$01
.4:
	STA	IT
.5:
	RTS
AUDIO:
	INC	FRMCNT
	LDA	FRMCNT
	AND	#$01
	TAX
AUDIO1:
	LDY	SOUND0,X
	LDA	AUDTAB,Y
	BEQ	AUDIO3
	INC	SOUND0,X
	CMP	#10
	BCS	AUDIO2
	STA	AUDC0,X
	BCC	AUDIO4
AUDIO2:
	STA	AUDF0,X
	LSR
	LSR
	LSR
	LSR
AUDIO3:
	STA	AUDV0,X
AUDIO4:
	LDY	#$00
	RTS
FARROW:
	LDA	FIRE,X
	BNE	.1
	LDA	$C,X
	BPL	.01
.0:
	JMP	.3
.01:
	LDA	DIR,X
	AND	#$EB
	BEQ	.0
	LDA	DIR,X
	ORA	#$02
	STA	FIRE,X
	LSR
	LSR
	TAY
	LDA	ARROWD,Y
	STA	ENEMTYP+2,X
	LDA	ARROWR,Y
	STA	ENEMREF+2,X
	LDA	ENEMHOR,X
	STA	ENEMHOR+2,X
	LDA	ENEMVER,X
	STA	ENEMVER+2,X
	LDA	#BULLET-AUDTAB
	STA	SOUND0
	BNE	.0
.1:
	STA	DIR+2,X
	LDY	ENEMHOR+2,X
	STY	NEWX1
	LDY	ENEMVER+2,X
	STY	NEWY1
	STX	TEMP
	LSR
	LSR
	STA	NEWDIR
	TAY
	LDX	ARROWX,Y
	LDA	ARROWY,Y
	JSR	PFCHK
	BNE	.2
	JSR	CKGUYS
	LDX	TEMP+2
	BPL	.15
	LDX	TEMP+3
	BMI	.25
.15:
	CPX	#$04
	BCC	.2
	CPX	#$0C
	BCS	.2
	LDA	#$84
	STA	ENEMTYP,X
	LDX	TEMP
	SED
	LDA	SCORLO,X
	CLC
	ADC	#$21
	STA	SCORLO,X
	LDA	SCORHI,X
	ADC	#$00
	STA	SCORHI,X
	LDA	#KILL-AUDTAB
	STA	SOUND0+1
	CLD
.2:
	LDX	TEMP
	LDA	#$00
	STA	DIR+2,X
	STA	FIRE,X
	LDA	#$FF
	STA	ENEMVER+2,X
	LDA	#$80
	STA	ENEMTYP+2,X
.25:
	LDX	TEMP
.3:
	RTS
****
*
* PROGRAM TO CHECK PLAYER AGAINST OBJECT
*
****
CKOBJECT:
	LDA	TEMP+2
	BMI	.01
	CMP	#$0C
	BCS	.1
.01:
	LDA	TEMP+3
	BMI	.0
	CMP	#$0C
	BCS	.1
.0:
	RTS
.1:
	TAY
	LDA	ENEMTYP,Y
	BEQ	.2
	CMP	#$01
	BEQ	.3
	CMP	#$02
	BEQ	.4
	CMP	#$03
	BEQ	.5
	RTS
.2:
* KEY
	LDA	KEYS,X
	CLC
	ADC	#$01
	CMP	#$06
	BEQ	.10
	STA	KEYS,X
	LDA	#KEYUP-AUDTAB
	STA	SOUND0+1
	BCC	.10
.3:
* KEYHOLE
	LDA	KEYS,X
	BEQ	.31
	SEC
	SBC	#$01
	STA	KEYS,X
	LDA	#KEYOPEN-AUDTAB
	STA	SOUND0+1
	BPL	.10
.31:
	RTS
.4:
* CHEST
	LDA	SCORLO,X
	SED
	CLC
	ADC	#$50
	STA	SCORLO,X
	LDA	SCORHI,X
	ADC	#$00
	STA	SCORHI,X
	CLD
	LDA	#CHESTUP-AUDTAB
	STA	SOUND0+1
	BPL	.10
.5:
* BOMB
.10:
	LDA	#$FF
	STA	ENEMVER,Y
	LDA	#$80
	STA	ENEMTYP,Y
	RTS
****
*
* PROGRAM TO ANIMATE PLAYER GIVEN INDEX OF PLAYER
*   USES NEWDIR PREVIOUSLY SET UP
*  X = INDEX OF PLAYER
****
ANIMATE:
	LDY	NEWDIR
	LDA	PLJOY,Y
	BPL	.1
	AND	#$7F
	BPL	.2
.1:
	CLC
	ADC	C1
.2:
	TAY
	LDA	ENEMTYP,X
	BPL	.4
	CMP	#$80
	BNE	.3
	LDA	#$FF
	STA	ENEMVER,X
	LDA	#$81
.3:
	SEC
	SBC	#$01
	STA	ENEMTYP,X
	LDA	#$00
	STA	DIR,X
	STA	ENEMREF,X
	RTS
.4:
	AND	#$F0
	ORA	PL,Y
	STA	ENEMTYP,X
	AND	#$0F
	TAY
	LDA	PREFTAB,Y
	STA	ENEMREF,X
	RTS
UPGUYS:
	LDX	#$0
	JSR	UPDIR
	LDX	#$1
	JSR	UPDIR
	LDX	#$2
	JSR	UPDIR
	LDX	#$3
	JSR	UPDIR
	LDA	C1
	AND	#$01
	BNE	.2
	LDX	#$0B
.1:
	JSR	UPDIR
	DEX
	CPX	#$07
	BNE	.1
	BEQ	.25
.2:
	LDX	#$07
.21:
	JSR	UPDIR
	DEX
	CPX	#$03
	BNE	.21
.25:
	LDA	ENEMVER+1
	CMP	#$FF
	BNE	.27
	LDA	ENEMVER
	JMP	.4
.27:
	LDA	ENEMVER
	CMP	#$FF
	BNE	.29
	LDA	ENEMVER+1
	JMP	.4
.29:
	SEC
	SBC	ENEMVER+1
	BCS	.3
	EOR	#$FF
	ADC	#$01
	LSR
	CLC
	ADC	ENEMVER
	BCC	.4
.3:
	LSR
	CLC
	ADC	ENEMVER+1
.4:
	SEC
	SBC	#35
	BCS	.5
	LDA	#$00
.5:
	CMP	#180
	BCC	.6
	LDA	#180
.6:
	STA	C
	RTS
CKGENER:
	STX	VTEMP+1
	LDX	#$0F
.1:
	LDA	ENEMTYP,X
	CMP	#$05
	BEQ	.2
	DEX
	CPX	#$0B
	BNE	.1
	RTS
.2:
	LDA	ENEMREF,X
	BEQ	.3
	SEC
	SBC	#$01
	STA	ENEMREF,X
	DEX
	CPX	#$0B
	BNE	.1
	RTS
.3:
	LDY	#$0B
.4:
	LDA	ENEMVER,Y
	CMP	#$FF
	BEQ	.5
	DEY
	CPY	#$03
	BNE	.4
	RTS
.5:
	LDA	#$07
	STA	ENEMREF,X
	LDA	ENEMHOR,X
	STA	ENEMHOR,Y
	LDA	ENEMVER,X
	STA	ENEMVER,Y
	LDA	#$30
	STA	ENEMTYP,Y
	LDA	#GENERATE-AUDTAB
	STA	SOUND0+1
	RTS

ENEMYUP:
	LDA	C1
	AND	#$01
	BNE	.2
	LDX	#$0B
.1:
	JSR	ENEMYUP1
	DEX
	CPX	#$07
	BNE	.1
	RTS
.2:
	LDX	#$07
.3:
	JSR	ENEMYUP1
	DEX
	CPX	#$03
	BNE	.3
	RTS
ENEMYUP1:
	LDA	ENEMVER,X
	CMP	#$FF
	BEQ	.5
	LDY	IT
	CMP	ENEMVER,Y
	BNE	.0
	LDA	#$00
	BEQ	.2
.0:
	BCC	.1
	LDA	#$20
	BNE	.2
.1:
	LDA	#$30
.2:
	STA	VTEMP+1
	LDA	ENEMHOR,X
	CMP	ENEMHOR,Y
	BNE	.25
	LDA	#$00
	BEQ	.4
.25:
	BCC	.3
	LDA	#$08
	BNE	.4
.3:
	LDA	#$0C
.4:
	ORA	VTEMP+1
	STA	DIR,X
	STX	VTEMP
	JSR	CKPF
	JSR	CKGUYS
	LDA	TEMP+2
	BPL	.6
	LDA	TEMP+3
	BPL	.6
.45:
	JSR	UPXY
	LDX	VTEMP
	JSR	ANIMATE
	RTS
.5:
	JSR	CKGENER
	LDX	VTEMP+1
	RTS
.6:
	CMP	#$02
	BCS	.45
	TAX
	LDA	ENEMTYP,X
	BMI	.45
	LDA	HEALTH,X
	SEC
	SBC	#$01
	STA	HEALTH,X
	BNE	.45
	LDA	#$84
	STA	ENEMTYP,X
	BNE	.45
****
*
* PROGRAM TO UPDATE VERTICAL AND HORIZONTAL LOCATIONS BY DIRECTION
*  GIVEN X = INDEX OF PLAYER
*  USES TEMP
****
UPDIR:
	STX	TEMP
	LDA	DIR,X		; STORE DIRECTION INTO NEWDIR
	BEQ	.3
	TAX
	LSR
	LSR
	TAY
	LDA	VERTJOY,Y	; STORE VECTORS INTO NEWX1, NEWY1
	STA	NEWY1
	LDA	HORIJOY,Y
	STA	NEWX1
	TXA			; SHIFT VECTORS BY LOWER 2 BITS IN DIR
	AND	#$03
	BEQ	.2
	TAX
.1:
	ASL	NEWX1
	ASL	NEWY1
	DEX
	BNE	.1
.2:
	CLC			; ADD VECTORS TO NEWX,NEWY AND STORE
	LDX	TEMP
	LDA	NEWX1
	ADC	ENEMHOR,X
	STA	ENEMHOR,X
	CLC
	LDA	NEWY1
	ADC	ENEMVER,X
	STA	ENEMVER,X
	LDA	#$00
	STA	DIR,X
.3:
	RTS
****
*
* CKPF
*
* PROGRAM TO CHECK PLAYER GIVEN TO THE PLAYFIELD TO SEE IF A COLLISION
*  IS TAKING PLACE.
*
* ON ENTRY X = PLAYER INDEX
*
* ON EXIT Z = 0 COLLISION
*	  Z = 1 NO COLLISION
*
* PROGRAM WILL GET THE DIRECTION OF PLAYER AND CHECK TO PLAYFIELD
*  ON EXIT NEW DIRECTION WILL BE STORED ACCORDING TO COLLISIONS
*
*  USES TEMP - 4
****
CKPF:
	STX	TEMP
	LDA	ENEMVER,X	; STORE OLD VALUES OF POSITION INTO NEWX,NEWY
	STA	NEWY
	LDA	ENEMHOR,X
	STA	NEWX
	LDA	DIR,X		; STORE DIRECTION INTO NEWDIR
	TAX
	LSR
	LSR
	STA	NEWDIR
	TAY
	LDA	VERTJOY,Y	; STORE VECTORS INTO NEWX1, NEWY1
	STA	NEWY1
	LDA	HORIJOY,Y
	STA	NEWX1
	TXA			; SHIFT VECTORS BY LOWER 2 BITS IN DIR
	AND	#$03
	BEQ	.2
	TAX
.1:
	ASL	NEWX1
	ASL	NEWY1
	DEX
	BNE	.1
.2:
	CLC			; ADD VECTORS TO NEWX,NEWY AND STORE
	LDA	NEWX1
	ADC	NEWX
	STA	NEWX1
	CLC
	LDA	NEWY1
	ADC	NEWY
	STA	NEWY1
	LDA	NEWDIR
	AND	#$08
	BEQ	.4
	LDA	#$00
	STA	TEMP+1		; MAKE MASKS FOR 3 DOTS IN VERTICAL CHECK
	STA	TEMP+2
	STA	TEMP+3
	LDA	#$01
	JSR	VERTCHK 	; CHECK 3 DOTS ALONG VERTICAL SIDE OF PLAYER
	LDA	#$04
	JSR	VERTCHK
	LDA	#$06
	JSR	VERTCHK
	LDA	NEWDIR		; CHECK IF UP/ DOWN
	LDX	#$08
	AND	#$04
	BEQ	.3
	LDX	#$0F		; UP = 8 DOWN = F
.3:
	TXA
	CLC
	ADC	NEWY1		; CHECK MASKS IN PF  TEMP+1 = PF0MASK
	LSR			;   TEMP+2 = PF1MASK
	LSR			;   TEMP+3 = PF2MASK
	TAY
	LDA	TEMP+1
	BEQ	.4
	AND	(ADPF0),Y
	BNE	.6
.4:
	LDA	TEMP+2
	BEQ	.5
	AND	(ADPF1),Y
	BNE	.6
.5:
	LDA	TEMP+3
	BEQ	.7
	AND	(ADPF2),Y
	BEQ	.7
.6:
	LDA	#$07
	AND	NEWDIR		; IF COLLISION THEN CLEAR UP/DOWN BIT
	STA	NEWDIR		; ALSO BRING Y VECTOR BACK
	LDA	NEWY
	STA	NEWY1
.7:
	LDA	NEWDIR
	AND	#$02		; CHECK FOR HORIZONTAL MOVEMENT
	BEQ	.10
	LDX	#$01
	LDA	NEWDIR
	AND	#$01
	BEQ	.8
	LDX	#$06
.8:
	STX	TEMP+1
	LDA	#$08
	JSR	PFCHK		; CHECK FOR THREE POINTS IN LEFT/ RIGHT SIDE
	BNE	.9
	LDX	TEMP+1
	LDA	#$0B
	JSR	PFCHK
	BNE	.9
	LDX	TEMP+1
	LDA	#$0F
	JSR	PFCHK
	BEQ	.10
.9:
	LDA	#$0D		; IF COLLISION THEN CLEAR LEFT/ RIGHT BIT
	AND	NEWDIR
	STA	NEWDIR
	LDA	NEWX
	STA	NEWX1
.10:
	RTS
UPXY:
	LDX	TEMP
	LDA	NEWDIR		; PUT DIRECTION IN TABLE
	ASL
	ASL
	STA	TEMP
	LDA	DIR,X
	AND	#$03
	ORA	TEMP
	CMP	DIR,X		; CHECK IF COLLISION
	STA	DIR,X
	RTS
****
*
* PROGRAM TO GET MASKS FOR VERTICAL CHECK
*
* ON ENTRY A = OFFSET FROM NEWX1
*
****
VERTCHK:
	CLC
	ADC	NEWX		; ADD OFFSET TO NEW X POSISION
	LSR
	LSR
	CMP	#20		; CHECK IF ON RIGHT SIDE
	BCC	.1
	EOR	#$FF
	ADC	#39
.1:
	TAX			; CHECK IF IN PF0 MASK
	LDA	PF0MSK,X
	BEQ	.2
	ORA	TEMP+1		; IF SO THEN OR THEM TOGETHER
	STA	TEMP+1
	RTS
.2:
	LDA	PF1MSK,X
	BEQ	.3
	ORA	TEMP+2
	STA	TEMP+2
	RTS
.3:
	LDA	PF2MSK,X
	ORA	TEMP+3
	STA	TEMP+3
	RTS
****
*
* PROGRAM TO CHECK DOT IN PF
*
* ON ENTRY A = Y OFFSET FROM NEWY1
*	   X = X OFFSET FROM NEWX1
* ON EXIT  A = 00 NO COLLISION	FF = COLLISION
*
****
PFCHK:
	CLC
	ADC	NEWY1		; ADD OFFSET TO NEW Y
	LSR
	LSR
	TAY
	TXA
	CLC
	ADC	NEWX1
	LSR
	LSR
	CMP	#20		; GET RIGHT SIDE FIXED
	BCC	.1
	EOR	#$FF
	ADC	#39
.1:
	TAX
	LDA	PF0MSK,X	; CHECK DOTS IN MASK TO PF
	BEQ	.2
	AND	(ADPF0),Y
	BNE	.5
	RTS
.2:
	LDA	PF1MSK,X
	BEQ	.3
	AND	(ADPF1),Y
	BNE	.5
	RTS
.3:
	LDA	PF2MSK,X
	BEQ	.4
	AND	(ADPF2),Y
	BNE	.5
.4:
	RTS
.5:
	LDA	#$FF
	RTS
CKGUYS:
	LDA	#$FF
	STA	TEMP+2
	STA	TEMP+3
	LDY	#$0F
.0:
	LDX	NEWDIR
	LDA	XMOV,X
	BEQ	.4
	CLC
	ADC	NEWX1
	AND	#$FC
	STA	TEMP+1
.1:
	LDA	ENEMHOR,Y
	AND	#$FC
	CMP	TEMP+1
	BEQ	.2
	DEY
	BPL	.1
	JMP	.4
.2:
	LDA	NEWY1
	SEC
	SBC	ENEMVER,Y
	BCS	.3
	EOR	#$FF
	ADC	#$01
.3:
	DEY
	CMP	#$08
	BCS	.0
	LDA	NEWDIR
	AND	#$0D
	STA	NEWDIR
	INY
	STY	TEMP+2
.4:
	LDY	#$F
.5:
	LDX	NEWDIR
	LDA	YMOV,X
	BEQ	.9
	CLC
	ADC	NEWY1
	AND	#$FC
	STA	TEMP+1
.6:
	LDA	ENEMVER,Y
	AND	#$FC
	CMP	TEMP+1
	BEQ	.7
	DEY
	BPL	.6
	RTS
.7:
	LDA	NEWX1
	SEC
	SBC	ENEMHOR,Y
	BCS	.8
	EOR	#$FF
	ADC	#$01
.8:
	DEY
	CMP	#$08
	BCS	.5
	LDA	NEWDIR
	AND	#$07
	STA	NEWDIR
	INY
	STY	TEMP+3
.9:
	RTS
STLEVEL:
	LDA	ENEMHOR,X
	CMP	#$00
	BNE	.4
	LDX	LEVEL
	DEX
	BPL	.1
	LDX	#$02
.1:
	STX	LEVEL
	LDA	LEVLO,X
	STA	ADDRP0
	LDA	LEVHI,X
	STA	ADDRP0+1
	LDY	#$07
.2:
	LDA	(ADDRP0),Y
	STA	ADPF0,Y
	DEY
	BPL	.2
	LDX	LEVEL
	LDA	GUYLO,X
	STA	ADDRP0
	LDA	GUYHI,X
	STA	ADDRP0+1
	LDY	#63
.25:
	LDA	(ADDRP0),Y
	STA	ENEMHOR,Y
	DEY
	BPL	.25
.3:
	RTS
.4:
	CMP	#159
	BNE	.3
	LDX	LEVEL
	INX
	CPX	#$03
	BNE	.1
	LDX	#$00
	BEQ	.1
	.ORG	$DC00
SCORE:
	STA	WSYNC
	STA	HMCLR
	LDA	#$00
	STA	COLUBK
	STA	COLUPF
	STA	REFP0
	STA	REFP1
	STA	GRP0
	STA	GRP1
	STA	PF0
	LDA	#$03
	STA	NUSIZ0
*	STA	ENABL
	LDA	#$01
	STA	NUSIZ1
	LDA	#$06
	STA	COUNTER
	LDA	#$FF
	STA	HMP0
	LDA	#$20
	STA	CTRLPF
	STA	WSYNC
	NOP
	LDA	#$34
	STA	COLUP0
	STA	COLUP1
	LDA	SCORHI
	LSR
	LSR
	LSR
	LSR
	TAX
	LDA	NUMLO,X
	STA	DI
	LDA	NUMHI,X
	STA	DI+1
	LDA	SCORHI
	AND	#$0F
	TAX
	LDA	NUMLO,X
	STA	RESP0
	STA	RESP1
	STA	DI+2
	LDA	NUMHI,X
	STA	WSYNC
	STA	DI+3
	LDX	HEALTH
	INX
	LDA	HTAB,X
	STA	HMBL
	LSR
	AND	#$07
	TAX
.1:
	DEX
*	BNE	.1
	STA	RESBL
	LDA	HEALTH
	LSR
	LSR
	TAX
	LDA	SCPF2,X
	STA	PF2
	LDA	SCPF1,X
	STA	PF1
	STA	WSYNC
	STA	HMOVE
	LDA	SCORLO
	LSR
	LSR
	LSR
	LSR
	TAX
	LDA	NUMLO,X
	STA	DI+4
	LDA	NUMHI,X
	STA	DI+5
	LDA	SCORLO
	AND	#$0F
	TAX
	LDA	NUMLO,X
	STA	DI+6
	LDA	NUMHI,X
	STA	DI+7
	LDA	KEYS
	CLC
	ADC	#$0A
	TAX
	LDA	NUMLO,X
	STA	KE
	LDA	NUMHI,X
	STA	KE+1
.2:
	STA	WSYNC
	NOP			;2
	LDA	#$36
	STA	COLUPF
	LDY	COUNTER 	;10
	NOP
	LDA	(KE),Y
	STA	GRP0		;20
	LDA	(DI),Y
	STA	GRP1		;28
	LDA	(DI+2),Y
	STA	TEMP
	LDA	(DI+4),Y	;41
	TAX
	LDA	(DI+6),Y	;48
	LDY	#$00
	STY	COLUPF		;53
	LDY	TEMP
	STY	GRP0		;59
	STX	GRP1
	STA	GRP0
	DEC	COUNTER 	;70
	BPL	.2
	LDA	#$00
	STA	GRP0
	STA	GRP1
SCORE1:
	STA	WSYNC
	STA	HMCLR
	LDA	#$00
	STA	COLUBK
	STA	COLUPF
	STA	REFP0
	STA	REFP1
	STA	GRP0
	STA	GRP1
	STA	PF0
	LDA	#$03
	STA	NUSIZ0
*	STA	ENABL
	LDA	#$01
	STA	NUSIZ1
	LDA	#$06
	STA	COUNTER
	LDA	#$FF
	STA	HMP0
	LDA	#$20
	STA	CTRLPF
	STA	WSYNC
	NOP
	LDA	#$E4
	STA	COLUP0
	STA	COLUP1
	LDA	SCORHI+1
	LSR
	LSR
	LSR
	LSR
	TAX
	LDA	NUMLO,X
	STA	DI
	LDA	NUMHI,X
	STA	DI+1
	LDA	SCORHI+1
	AND	#$0F
	TAX
	LDA	NUMLO,X
	STA	RESP0
	STA	RESP1
	STA	DI+2
	LDA	NUMHI,X
	STA	WSYNC
	STA	DI+3
	LDX	HEALTH1
	INX
	LDA	HTAB,X
	STA	HMBL
	LSR
	AND	#$07
	TAX
.1:
	DEX
*	BNE	.1
	STA	RESBL
	LDA	HEALTH1
	LSR
	LSR
	TAX
	LDA	SCPF2,X
	STA	PF2
	LDA	SCPF1,X
	STA	PF1
	STA	WSYNC
	STA	HMOVE
	LDA	SCORLO+1
	LSR
	LSR
	LSR
	LSR
	TAX
	LDA	NUMLO,X
	STA	DI+4
	LDA	NUMHI,X
	STA	DI+5
	LDA	SCORLO+1
	AND	#$0F
	TAX
	LDA	NUMLO,X
	STA	DI+6
	LDA	NUMHI,X
	STA	DI+7
	LDA	KEYS+1
	CLC
	ADC	#$0A
	TAX
	LDA	NUMLO,X
	STA	KE
	LDA	NUMHI,X
	STA	KE+1
.2:
	STA	WSYNC
	NOP
	LDA	#$E6
	STA	COLUPF
	LDY	COUNTER
	NOP
	LDA	(KE),Y
	STA	GRP0
	LDA	(DI),Y
	STA	GRP1
	LDA	(DI+2),Y
	STA	TEMP
	LDA	(DI+4),Y
	TAX
	LDA	(DI+6),Y
	LDY	#$00
	STY	COLUPF
	LDY	TEMP
	STY	GRP0
	STX	GRP1
	STA	GRP0
	DEC	COUNTER
	BPL	.2
	LDA	#$00
	STA	GRP0
	STA	GRP1
	LDX	#30
.10:
	STA	WSYNC
	DEX
	BNE	.10
	JMP	PFDONE
	.ORG	$D000
SOUND0: .DS.B	2
FRMCNT: .DS.B	1
LEVEL:	.DS.B	1
HEALTH:
	DC.B	$3F
HEALTH1:
	DC.B	$3F
NUMLO:
	DC.B	DIG0&$FF,DIG1&$FF,DIG2&$FF,DIG3&$FF,DIG4&$FF,DIG5&$FF
	DC.B	DIG6&$FF,DIG7&$FF,DIG8&$FF,DIG9&$FF
	DC.B	KEY0&$FF,KEY1&$FF,KEY2&$FF,KEY3&$FF,KEY4&$FF,KEY5&$FF
NUMHI:
	DC.B	DIG0/256,DIG1/256,DIG2/256,DIG3/256,DIG4/256,DIG5/256
	DC.B	DIG6/256,DIG7/256,DIG8/256,DIG9/256
	DC.B	KEY0/256,KEY1/256,KEY2/256,KEY3/256,KEY4/256,KEY5/256
DIG0:
	DC.B	$3E,$41,$41,$41,$41,$41,$3E
DIG1:
	DC.B	$1C,$08,$08,$08,$08,$18,$08
DIG2:
	DC.B	$3E,$41,$40,$30,$0E,$41,$3E
DIG3:
	DC.B	$3E,$41,$01,$01,$06,$41,$3E
DIG4:
	DC.B	$04,$04,$04,$04,$7F,$24,$1C
DIG5:
	DC.B	$3E,$41,$01,$01,$7E,$40,$7F
DIG6:
	DC.B	$3E,$41,$41,$41,$7E,$40,$3E
DIG7:
	DC.B	$04,$04,$02,$02,$01,$01,$3E
DIG8:
	DC.B	$3E,$41,$41,$41,$3E,$41,$3E
DIG9:
	DC.B	$3E,$41,$01,$01,$3F,$41,$3E
KEY0:
	DC.B	$66,$49,$69,$49,$69,$69,$66
KEY1:
	DC.B	$6E,$44,$64,$44,$64,$6C,$64
KEY2:
	DC.B	$66,$49,$68,$44,$62,$69,$66
KEY3:
	DC.B	$66,$49,$61,$41,$62,$69,$66
KEY4:
	DC.B	$62,$42,$62,$4F,$6A,$66,$62
KEY5:
	DC.B	$55,$49,$61,$41,$6E,$68,$6F
SCPF2:
	DC.B	$00,$00,$00,$00,$00,$00,$00,$00,$00
	DC.B	$00,$01,$03,$07,$0F,$1F,$3F,$7F,$FF
SCPF1:
	DC.B	$00,$00,$80,$C0,$E0,$F0,$F8,$FC,$FE
	DC.B	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
GUYLO:
	DC.B	THOR&$FF,UHOR&$FF,VHOR&$FF
GUYHI:
	DC.B	THOR/256,UHOR/256,VHOR/256
HORIJOY:
	DC.B	$00,$00,$FF,$01
	DC.B	$00,$00,$FF,$01,$00,$00,$FF,$01,$00,$00,$FF,$01
VERTJOY:
	DC.B	$00,$00,$00,$00
	DC.B	$00,$00,$00,$00,$FF,$FF,$FF,$FF,$01,$01,$01,$01
XMOV:
	DC.B	$00,$00,$F9,$07
	DC.B	$00,$00,$F9,$07,$00,$00,$F9,$07,$00,$00,$F9,$07
YMOV:
	DC.B	$00,$00,$00,$00
	DC.B	$00,$00,$00,$00,$F9,$F9,$F9,$F9,$07,$07,$07,$07
ARROWX:
	DC.B	$00,$00,$00,$08
	DC.B	$00,$00,$00,$00,$04,$00,$00,$08,$04,$00,$00,$08
ARROWY:
	DC.B	$00,$00,$07,$07
	DC.B	$00,$00,$00,$00,$02,$00,$02,$02,$0E,$00,$0E,$0E
ARROWD:
	DC.B	$00,$00,$06,$06
	DC.B	$00,$00,$00,$00,$09,$00,$07,$07,$0A,$00,$08,$08
ARROWR:
	DC.B	$00,$00,$08,$00
	DC.B	$00,$00,$00,$00,$00,$00,$08,$00,$00,$00,$08,$00
PLJOY:
	DC.B	$98,$98,$00,$08,$98,$98,$00,$08,$10,$10,$00,$08,$18,$18,$00,$08
OBJVER:
	DC.B	$00,$00,$00
OBJTYP:
	DC.B	$00,$00,$00
OBJHOR:
	DC.B	$45,$46,$47
DIRJOY:
	DC.B	$00,$00,$00,$00
	DC.B	$00,$3C,$2C,$0C,$00,$38,$28,$08,$00,$30,$20,$00
PF0MSK:
	DC.B	$10,$20,$40,$80
	DC.B	$00,$00,$00,$00
PF2MSK:
	DC.B	$00,$00,$00,$00
	DC.B	$00,$00,$00,$00,$00,$00,$00,$00
	DC.B	$01,$02,$04,$08,$10,$20,$40,$80
PF1MSK:
	DC.B	$00,$00,$00,$00
	DC.B	$80,$40,$20,$10,$08,$04,$02,$01
	DC.B	$00,$00,$00,$00,$00,$00,$00,$00
PL:
	DC.B	$00,$01,$01,$02,$02,$01,$01,$00
	DC.B	$03,$04,$04,$05,$05,$04,$04,$03
	DC.B	$06,$07,$08,$07,$06,$09,$0A,$09
	DC.B	$0B,$0C,$0D,$0C,$0B,$0E,$0F,$0E
LEVLO:
	DC.B	TPFTAB&$FF,UPFTAB&$FF,VPFTAB&$FF
LEVHI:
	DC.B	TPFTAB/256,UPFTAB/256,VPFTAB/256
TPFTAB:
	DC.B	TPF0&$FF,TPF0/256,TPF1&$FF,TPF1/256,TPF2&$FF,TPF2/256,$32,$06
UPFTAB:
	DC.B	UPF0&$FF,UPF0/256,UPF1&$FF,UPF1/256,UPF2&$FF,UPF2/256,$D2,$06
VPFTAB:
	DC.B	VPF0&$FF,VPF0/256,VPF1&$FF,VPF1/256,VPF2&$FF,VPF2/256,$02,$06
	.ORG	$D200
TPF0:
	dc.b $F0,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
	dc.b $F0,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
	dc.b $10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$10,$10,$10,$10,$10,$10
	dc.b $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$F0
TPF1:
	dc.b $FF,$00,$00,$00,$00,$00,$00,$00,$80,$80,$80,$FF,$00,$00,$00,$00
	dc.b $FF,$00,$00,$00,$00,$00,$FF,$80,$80,$80,$FF,$00,$00,$00,$00,$00
	dc.b $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dc.b $00,$00,$00,$FF,$01,$01,$01,$FF,$80,$80,$80,$80,$FF,$00,$00,$FF
TPF2:
	dc.b $FF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dc.b $03,$02,$02,$00,$00,$00,$0F,$00,$00,$00,$0F,$00,$00,$00,$00,$00
	dc.b $00,$00,$FF,$01,$00,$00,$00,$00,$00,$01,$01,$01,$01,$FF,$00,$00
	dc.b $00,$00,$00,$00,$00,$FF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF
UPF0:
	dc.b $F0,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
	dc.b $F0,$10,$10,$10,$10,$10,$10,$90,$90,$90,$90,$10,$10,$90,$10,$10
	dc.b $10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$10,$10,$10,$10,$10,$10
	dc.b $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$F0
UPF1:
	dc.b $FF,$00,$00,$00,$00,$00,$00,$00,$80,$80,$80,$80,$FF,$00,$00,$00
	dc.b $FF,$00,$00,$00,$00,$00,$FF,$00,$00,$00,$FF,$00,$00,$FF,$00,$00
	dc.b $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dc.b $00,$00,$00,$FF,$01,$01,$01,$FF,$80,$80,$80,$80,$FF,$00,$00,$FF
UPF2:
	dc.b $FF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dc.b $03,$02,$02,$00,$00,$00,$FF,$00,$00,$00,$7F,$00,$00,$7F,$00,$00
	dc.b $00,$00,$FF,$01,$01,$01,$01,$00,$00,$01,$01,$01,$01,$FF,$00,$00
	dc.b $00,$00,$00,$00,$00,$FF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF
VPF0:
	dc.b $F0,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10
	dc.b $F0,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$90,$10,$10
	dc.b $10,$10,$10,$10,$10,$10,$00,$00,$00,$00,$10,$10,$10,$10,$10,$10
	dc.b $10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$F0
VPF1:
	dc.b $FF,$00,$00,$00,$00,$00,$00,$00,$80,$80,$80,$80,$FF,$00,$00,$00
	dc.b $FF,$00,$00,$00,$00,$00,$FF,$00,$00,$00,$FF,$00,$00,$FF,$00,$00
	dc.b $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dc.b $00,$00,$00,$FF,$01,$01,$01,$FF,$80,$80,$80,$80,$FF,$00,$00,$FF
VPF2:
	dc.b $FF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dc.b $03,$02,$02,$00,$00,$00,$FF,$00,$00,$00,$7F,$00,$00,$7F,$00,$00
	dc.b $00,$00,$FF,$01,$0F,$01,$01,$00,$00,$01,$01,$01,$01,$FF,$00,$00
	dc.b $00,$00,$00,$00,$00,$FF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF
PLAYER1:
	DC.B	$3E,$3C,$3C,$3C,$3C,$3C,$7E,$7E,$7E,$3C,$3C,$3C,$3C,$38
PLAYER2:
	DC.B	$77,$66,$76,$3E,$3C,$3C,$3F,$7E,$7E,$3C,$3C,$3C,$3C,$38
PLAYER3:
	DC.B	$E7,$C6,$66,$7E,$3C,$3C,$3F,$7E,$7E,$3C,$3C,$3C,$3C,$38
PLAYER4:
	DC.B	$7E,$3C,$3C,$3C,$3C,$3C,$7E,$7E,$7E,$3C,$3C,$3C,$3C,$3C
PLAYER5:
	DC.B	$70,$3E,$3C,$3C,$3C,$3C,$3E,$7E,$7E,$3C,$3C,$3C,$3C,$3C
PLAYER6:
	DC.B	$70,$30,$3E,$3C,$3C,$3C,$3E,$7E,$7E,$3C,$3C,$3C,$3C,$3C
PLAYER7:
	DC.B	$0E,$7C,$3C,$3C,$3C,$3C,$7C,$7E,$7E,$3C,$3C,$3C,$3C,$3C
PLAYER8:
	DC.B	$0E,$0C,$7C,$3C,$3C,$3C,$7C,$7E,$7E,$3C,$3C,$3C,$3C,$3C
PLAYER1C:
	DC.B	$34,$34,$34,$34,$34,$32,$34,$34,$34,$34,$F8,$F8,$F8,$18
PLAYER2C:
	DC.B	$34,$34,$34,$34,$34,$32,$34,$34,$34,$34,$F8,$18,$18,$18
PLAYER3C:
	DC.B	$E4,$E4,$E4,$E4,$E4,$E2,$E4,$E4,$E4,$E4,$F8,$F8,$F8,$02
PLAYER4C:
	DC.B	$E4,$E4,$E4,$E4,$E4,$E2,$E4,$E4,$E4,$E4,$F8,$02,$02,$02
GRUNT1:
	DC.B	$3E,$3C,$3C,$3C,$3C,$26,$2E,$3E,$3C,$3C,$3C,$3C,$3C,$00
GRUNT2:
	DC.B	$77,$7E,$3E,$3C,$3C,$32,$36,$3E,$3C,$3C,$3C,$3C,$3C,$00
GRUNT3:
	DC.B	$67,$FE,$7E,$3C,$3C,$32,$36,$3E,$3C,$3C,$3C,$3C,$3C,$00
GRUNT4:
	DC.B	$7E,$3C,$3C,$3C,$BD,$BD,$BD,$FF,$7E,$3C,$3C,$3C,$3C,$00
GRUNT5:
	DC.B	$70,$3E,$3C,$3C,$BD,$BD,$BD,$FF,$7E,$3C,$3C,$3C,$3C,$00
GRUNT6:
	DC.B	$70,$30,$3E,$3C,$BD,$BD,$BD,$FF,$7E,$3C,$3C,$3C,$3C,$00
GRUNT7:
	DC.B	$0E,$7C,$3C,$3C,$BD,$BD,$BD,$FF,$7E,$3C,$3C,$3C,$3C,$00
GRUNT8:
	DC.B	$0E,$0C,$7C,$3C,$BD,$BD,$BD,$FF,$7E,$3C,$3C,$3C,$3C,$00
GREEN:
	DC.B	$C4,$C4,$C4,$C2,$C4,$C4,$C4,$C4,$C4,$24,$24,$24,$C4,$00
GREEN1:
	DC.B	$C4,$C4,$C4,$C2,$C4,$C4,$C4,$C4,$C4,$24,$C4,$C4,$C4,$00
GHOST1:
	DC.B	$FC,$7C,$3E,$3E,$3F,$1E,$1E,$0F,$0F,$0F,$07,$00,$00,$00
GHOST2:
	DC.B	$F8,$FC,$7C,$3E,$3F,$1E,$1E,$0F,$0F,$0F,$07,$00,$00,$00
GHOST3:
	DC.B	$FC,$7C,$3E,$3E,$1F,$1E,$1E,$0F,$0F,$0F,$07,$00,$00,$00
GHOST4:
	DC.B	$3F,$7E,$7E,$7E,$FE,$7C,$38,$38,$38,$38,$10,$00,$00,$00
GHOST5:
	DC.B	$1F,$3F,$7E,$7E,$FE,$7C,$38,$38,$38,$38,$10,$00,$00,$00
GHOST6:
	DC.B	$3F,$3F,$7E,$7E,$FE,$7C,$38,$38,$38,$38,$10,$00,$00,$00
GHOST7:
	DC.B	$FC,$7E,$7E,$3E,$3F,$3E,$1C,$14,$14,$14,$08,$00,$00,$00
GHOST8:
	DC.B	$F8,$FC,$7E,$3E,$3F,$3E,$1C,$14,$14,$14,$08,$00,$00,$00
GHOST9:
	DC.B	$FC,$7C,$3E,$3E,$3F,$3E,$1C,$14,$14,$14,$08,$00,$00,$00
GHOSTC:
	DC.B	$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C
SKELT1:
	DC.B	$18,$10,$10,$10,$14,$08,$30,$18,$30,$00,$18,$38,$30,$18
SKELT2:
	DC.B	$3C,$28,$28,$10,$12,$04,$38,$18,$30,$00,$18,$38,$30,$18
SKELT3:
	DC.B	$63,$42,$42,$24,$18,$42,$34,$18,$30,$00,$18,$38,$30,$18
SKELT4:
	DC.B	$63,$14,$14,$14,$55,$41,$5D,$41,$36,$00,$1C,$1C,$1C,$1C
SKELT5:
	DC.B	$60,$13,$14,$14,$55,$41,$5D,$41,$36,$00,$1C,$1C,$1C,$1C
SKELT6:
	DC.B	$03,$64,$14,$14,$55,$41,$5D,$41,$36,$00,$1C,$1C,$1C,$1C
SKELT7:
	DC.B	$63,$14,$14,$14,$55,$41,$5D,$41,$36,$00,$14,$1C,$08,$1C
SKELT8:
	DC.B	$60,$13,$14,$14,$55,$41,$5D,$41,$36,$00,$14,$1C,$08,$1C
SKELT9:
	DC.B	$03,$64,$14,$14,$55,$41,$5D,$41,$36,$00,$14,$1C,$08,$1C
SKELTC:
	DC.B	$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C
WIZRD1:
	DC.B	$FC,$7C,$7E,$7E,$3F,$3F,$3E,$3E,$1C,$1C,$1C,$1C,$38,$10
WIZRD2:
	DC.B	$7E,$7E,$7E,$3E,$3E,$3F,$3F,$3E,$1C,$1C,$1C,$1C,$38,$10
WIZRD3:
	DC.B	$FF,$7F,$7F,$7E,$3E,$3F,$3F,$3E,$1C,$1C,$1C,$1C,$38,$10
WIZRD4:
	DC.B	$1C,$3E,$3E,$3E,$7F,$7F,$7F,$7F,$3E,$1C,$1C,$1C,$1C,$08
WIZRD5:
	DC.B	$18,$3C,$3E,$3E,$3F,$7F,$7F,$7F,$3E,$1C,$1C,$1C,$1C,$08
WIZRD6:
	DC.B	$18,$3C,$3C,$3E,$3F,$7F,$7F,$7F,$3E,$1C,$1C,$1C,$1C,$08
WIZRD7:
	DC.B	$0C,$1E,$3E,$3E,$7E,$7F,$7F,$7F,$3E,$1C,$1C,$1C,$1C,$08
WIZRD8:
	DC.B	$0C,$1E,$1E,$3E,$7E,$7F,$7F,$7F,$3E,$1C,$1C,$1C,$1C,$08
WIZRD1C:
	DC.B	$76,$76,$76,$76,$76,$76,$76,$76,$76,$26,$26,$26,$76,$76
WIZRD2C:
	DC.B	$76,$76,$76,$76,$76,$76,$76,$76,$76,$26,$76,$76,$76,$76
DEATH1:
	DC.B	$F8,$78,$7C,$7C,$3E,$3E,$3E,$3F,$3C,$38,$38,$18,$18,$0C
DEATH2:
	DC.B	$F0,$F8,$78,$7C,$3E,$3E,$3E,$3F,$3C,$38,$38,$18,$18,$0C
DEATH3:
	DC.B	$F8,$7C,$7E,$3E,$3E,$3E,$3E,$3F,$3C,$38,$38,$18,$18,$0C
DEATH4:
	DC.B	$FF,$7F,$3F,$3E,$1E,$1F,$0F,$0F,$0F,$1F,$3E,$6E,$4E,$04
DEATH5:
	DC.B	$7F,$7F,$7E,$3E,$1E,$1F,$0F,$0F,$0F,$1F,$3E,$6E,$4E,$04
DEATH6:
	DC.B	$FF,$7F,$7E,$3E,$1E,$1F,$0F,$0F,$0F,$1F,$3E,$6E,$4E,$04
DEATH7:
	DC.B	$FF,$FE,$FC,$7C,$78,$F8,$F0,$F6,$FC,$D8,$50,$50,$50,$20
DEATH8:
	DC.B	$FE,$FE,$7E,$7C,$78,$F8,$F0,$F6,$FC,$D8,$50,$50,$50,$20
DEATH9:
	DC.B	$FE,$FE,$7C,$7C,$F8,$F8,$F0,$F6,$FC,$D8,$50,$50,$50,$20
DEATHC:
	DC.B	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
KEY:
	DC.B	$00,$00,$00,$00,$00,$35,$4F,$30,$00,$00,$00,$00,$00,$00
KEYC:
	DC.B	$00,$00,$00,$00,$00,$1A,$1A,$1A,$00,$00,$00,$00,$00,$00
KEYHOLE:
	DC.B	$7F,$7F,$7F,$77,$77,$77,$63,$41,$41,$63,$77,$7F,$7F,$3E
KEYHC:
	DC.B	$12,$16,$1A,$1A,$1A,$1A,$1A,$1A,$1A,$1A,$1A,$1A,$1A,$22
CHEST:
	DC.B	$7F,$7F,$7F,$6B,$77,$7F,$3E,$00,$00,$00,$00,$00,$00,$00
CHESTC:
	DC.B	$20,$24,$24,$24,$24,$20,$24,$00,$00,$00,$00,$00,$00,$00
BOMB:
	DC.B	$1C,$3E,$7F,$7F,$3E,$1C,$08,$04,$00,$00,$00,$00,$00,$00
BOMBC:
	DC.B	$46,$46,$46,$46,$46,$46,$00,$00,$00,$00,$00,$00,$00,$00
ARROW1:
	DC.B	$00,$00,$00,$00,$00,$40,$FF,$40,$00,$00,$00,$00,$00,$00
ARROW2:
	DC.B	$00,$00,$00,$00,$A0,$40,$A0,$10,$08,$04,$02,$01,$00,$00
ARROW3:
	DC.B	$01,$02,$04,$08,$10,$A0,$40,$A0,$00,$00,$00,$00,$00,$00
ARROW4:
	DC.B	$00,$00,$00,$00,$08,$1C,$08,$08,$08,$08,$08,$08,$00,$00
ARROW5:
	DC.B	$08,$08,$08,$08,$08,$08,$1C,$08,$00,$00,$00,$00,$00,$00
ARROWC:
	DC.B	$0E,$0E,$0E,$0E,$0E,$0E,$0E,$0E,$0E,$0E,$0E,$0E,$0E,$0E
POISON:
	DC.B	$E7,$10,$08,$E7,$1C,$62,$FF,$EB,$C9,$FF,$7E,$00,$00,$00
POISONC:
	DC.B	$08,$08,$08,$08,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$00,$00,$00
FOOD:
	DC.B	$7E,$EB,$F7,$EB,$7F,$1E,$0D,$0C,$00,$00,$00,$00,$00,$00
FOODC:
	DC.B	$F4,$F4,$F4,$F4,$F4,$F4,$F4,$32,$00,$00,$00,$00,$00,$00
EXPLO4:
	DC.B	$00,$00,$00,$00,$00,$00,$18,$00,$00,$00,$00,$00,$00,$00
EXPLO3:
	DC.B	$00,$00,$00,$00,$00,$24,$18,$24,$00,$00,$00,$00,$00,$00
EXPLO2:
	DC.B	$00,$00,$00,$00,$42,$24,$18,$24,$42,$00,$00,$00,$00,$00
EXPLO1:
	DC.B	$00,$00,$00,$81,$42,$24,$18,$24,$42,$81,$00,$00,$00,$00
NONE:
	DC.B	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
PDATA:
* OBJECTS
	DC.B	$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$00,$00,$00,$00,$00
* PLAYER0
	DC.B	$0B,$0C,$0D,$0B,$0C,$0D,$0E,$0F,$10,$11,$12,$0E,$0F,$10,$11,$12
* PLAYER1
	DC.B	$0B,$0C,$0D,$0B,$0C,$0D,$0E,$0F,$10,$11,$12,$0E,$0F,$10,$11,$12
* GRUNT
	DC.B	$13,$14,$15,$13,$14,$15,$16,$17,$18,$19,$1A,$16,$17,$18,$19,$1A
* GHOST
	DC.B	$1B,$1C,$1D,$1B,$1C,$1D,$1E,$1F,$20,$20,$1F,$21,$22,$23,$23,$22
* SKELETON
	DC.B	$24,$25,$26,$24,$25,$26,$27,$27,$28,$27,$29,$2A,$2A,$2B,$2A,$2C
* WIZARD
	DC.B	$2D,$2E,$2F,$2D,$2E,$2F,$30,$31,$32,$33,$34,$30,$31,$32,$33,$34
* DEATH
	DC.B	$35,$36,$37,$35,$36,$37,$38,$39,$3A,$3A,$39,$3B,$3C,$3D,$3D,$3C
* EMPTY
	DC.B	$3E,$3F,$40,$41,$42
PCOLOR:
* OBJECTS
	DC.B	$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$00,$00,$00,$00,$00
* PLAYER0
	DC.B	$0B,$0B,$0B,$0B,$0B,$0B,$0C,$0C,$0C,$0C,$0C,$0B,$0B,$0B,$0B,$0B
* PLAYER1
	DC.B	$0D,$0D,$0D,$0D,$0D,$0D,$0E,$0E,$0E,$0E,$0E,$0D,$0D,$0D,$0D,$0D
* GRUNT
	DC.B	$0F,$0F,$0F,$0F,$0F,$0F,$10,$10,$10,$10,$10,$0F,$0F,$0F,$0F,$0F
* GHOST
	DC.B	$11,$11,$11,$11,$11,$11,$11,$11,$11,$11,$11,$11,$11,$11,$11,$11
* SKELETON
	DC.B	$12,$12,$12,$12,$12,$12,$12,$12,$12,$12,$12,$12,$12,$12,$12,$12
* WIZARD
	DC.B	$13,$13,$13,$13,$13,$13,$14,$14,$14,$14,$14,$13,$13,$13,$13,$13
* DEATH
	DC.B	$15,$15,$15,$15,$15,$15,$15,$15,$15,$15,$15,$15,$15,$15,$15,$15
* EMPTY
	DC.B	$16,$11,$11,$11,$11
PREFTAB:
	DC.B	$08,$08,$08
	DC.B	$00,$00,$00
	DC.B	$00,$00,$00,$00,$00
	DC.B	$00,$00,$00,$00,$00
PTYPELO:
	DC.B	KEY&$FF,KEYHOLE&$FF
	DC.B	CHEST&$FF,BOMB&$FF,FOOD&$FF
	DC.B	POISON&$FF,ARROW1&$FF,ARROW2&$FF
	DC.B	ARROW3&$FF,ARROW4&$FF,ARROW5&$FF
* $B
	DC.B	PLAYER1&$FF,PLAYER2&$FF,PLAYER3&$FF
	DC.B	PLAYER4&$FF,PLAYER5&$FF,PLAYER6&$FF
	DC.B	PLAYER7&$FF,PLAYER8&$FF
* $13
	DC.B	GRUNT1&$FF,GRUNT2&$FF,GRUNT3&$FF
	DC.B	GRUNT4&$FF,GRUNT5&$FF,GRUNT6&$FF
	DC.B	GRUNT7&$FF,GRUNT8&$FF
* $1B
	DC.B	GHOST1&$FF,GHOST2&$FF,GHOST3&$FF
	DC.B	GHOST4&$FF,GHOST5&$FF,GHOST6&$FF
	DC.B	GHOST7&$FF,GHOST8&$FF,GHOST9&$FF
* $24
	DC.B	SKELT1&$FF,SKELT2&$FF,SKELT3&$FF
	DC.B	SKELT4&$FF,SKELT5&$FF,SKELT6&$FF
	DC.B	SKELT7&$FF,SKELT8&$FF,SKELT9&$FF
* $2D
	DC.B	WIZRD1&$FF,WIZRD2&$FF,WIZRD3&$FF
	DC.B	WIZRD4&$FF,WIZRD5&$FF,WIZRD6&$FF
	DC.B	WIZRD7&$FF,WIZRD8&$FF
* $35
	DC.B	DEATH1&$FF,DEATH2&$FF,DEATH3&$FF
	DC.B	DEATH4&$FF,DEATH5&$FF,DEATH6&$FF
	DC.B	DEATH7&$FF,DEATH8&$FF,DEATH9&$FF
	DC.B	NONE&$FF,EXPLO1&$FF,EXPLO2&$FF
	DC.B	EXPLO3&$FF,EXPLO4&$FF
PTYPEHI:
	DC.B	KEY/256,KEYHOLE/256
	DC.B	CHEST/256,BOMB/256,FOOD/256
	DC.B	POISON/256,ARROW1/256,ARROW2/256
	DC.B	ARROW3/256,ARROW4/256,ARROW5/256
	DC.B	PLAYER1/256,PLAYER2/256,PLAYER3/256
	DC.B	PLAYER4/256,PLAYER5/256,PLAYER6/256
	DC.B	PLAYER7/256,PLAYER8/256
	DC.B	GRUNT1/256,GRUNT2/256,GRUNT3/256
	DC.B	GRUNT4/256,GRUNT5/256,GRUNT6/256
	DC.B	GRUNT7/256,GRUNT8/256
	DC.B	GHOST1/256,GHOST2/256,GHOST3/256
	DC.B	GHOST4/256,GHOST5/256,GHOST6/256
	DC.B	GHOST7/256,GHOST8/256,GHOST9/256
	DC.B	SKELT1/256,SKELT2/256,SKELT3/256
	DC.B	SKELT4/256,SKELT5/256,SKELT6/256
	DC.B	SKELT7/256,SKELT8/256,SKELT9/256
	DC.B	WIZRD1/256,WIZRD2/256,WIZRD3/256
	DC.B	WIZRD4/256,WIZRD5/256,WIZRD6/256
	DC.B	WIZRD7/256,WIZRD8/256
	DC.B	DEATH1/256,DEATH2/256,DEATH3/256
	DC.B	DEATH4/256,DEATH5/256,DEATH6/256
	DC.B	DEATH7/256,DEATH8/256,DEATH9/256
	DC.B	NONE/256,EXPLO1/256,EXPLO2/256
	DC.B	EXPLO3/256,EXPLO4/256
COLO:
	DC.B	KEYC&$FF,KEYHC&$FF
	DC.B	CHESTC&$FF,BOMBC&$FF,FOODC&$FF
	DC.B	POISONC&$FF,ARROWC&$FF,ARROWC&$FF
	DC.B	ARROWC&$FF,ARROWC&$FF,ARROWC&$FF
* $B
	DC.B	PLAYER1C&$FF,PLAYER2C&$FF,PLAYER3C&$FF
	DC.B	PLAYER4C&$FF
* $F
	DC.B	GREEN&$FF,GREEN1&$FF
	DC.B	GHOSTC&$FF
	DC.B	SKELTC&$FF
	DC.B	WIZRD1C&$FF,WIZRD2C&$FF
	DC.B	DEATHC&$FF
	DC.B	NONE&$FF
COHI:
	DC.B	KEYC/256,KEYHC/256
	DC.B	CHESTC/256,BOMBC/256,FOODC/256
	DC.B	POISONC/256,ARROWC/256,ARROWC/256
	DC.B	ARROWC/256,ARROWC/256,ARROWC/256
	DC.B	PLAYER1C/256,PLAYER2C/256,PLAYER3C/256
	DC.B	PLAYER4C/256
	DC.B	GREEN/256,GREEN1/256
	DC.B	GHOSTC/256
	DC.B	SKELTC/256
	DC.B	WIZRD1C/256,WIZRD2C/256
	DC.B	DEATHC/256
	DC.B	NONE/256
LTAB:
	DC.B	$5,$4,$3,$2
AUDTAB:
	DC.B	$00
	.MACRO	FV FRQ, VOL
	.DC.B	\VOL*$10&$E0|\FRQ
	.ENDM
BULLET:
	DC.B	6
	FV	$17,5
	FV	$17,5
	FV	$17,5
	FV	$16,5
	FV	$15,5
	FV	$14,5
	FV	$12,5
	FV	$0F,5
	FV	$0B,5
	FV	$07,5
	DC.B	00
KILL:	DC.B	1,$62,$63,$44,$49,$00
KEYUP:
	DC.B	4
	FV	$04,6
	FV	$04,4
	FV	$07,4
	FV	$07,4
	FV	$0A,4
	FV	$0A,2
	FV	$04,2
	FV	$04,2
KEYOPEN:
	DC.B	$D
	FV	$0C,6
	FV	$0C,4
	FV	$0A,4
	FV	$0A,4
	FV	$0B,4
	FV	$0B,2
	FV	$08,2
	FV	$08,2
GENERATE:
	DC.B	$4
	FV	$03,2
	FV	$03,2
	FV	$03,2
	FV	$0A,2
	FV	$0B,4
	FV	$0B,4
	FV	$08,6
	FV	$08,6
CHESTUP:
	DC.B	$4
	FV	$06,2
	FV	$06,2
	FV	$04,2
	FV	$04,4
	FV	$02,4
	FV	$02,4
	FV	$04,2
	FV	$06,2
	.ORG	$FE00
HTAB:
	DC.B $33,$23,$13,$03
	DC.B $F3,$E3,$D3,$C3,$B3,$A3,$93
	DC.B $75,$65,$55,$45,$35,$25,$15,$05
	DC.B $F5,$E5,$D5,$C5,$B5,$A5,$95
	DC.B $77,$67,$57,$47,$37,$27,$17,$07
	DC.B $F7,$E7,$D7,$C7,$B7,$A7,$97
	DC.B $79,$69,$59,$49,$39,$29,$19,$09
	DC.B $F9,$E9,$D9,$C9,$B9,$A9,$99
	DC.B $7B,$6B,$5B,$4B,$3B,$2B,$1B,$0B
	DC.B $FB,$EB,$DB,$CB,$BB,$AB,$9B
	DC.B $72,$62,$52,$42,$32,$22,$12,$02
	DC.B $F2,$E2,$D2,$C2,$B2,$A2,$92
	DC.B $74,$64,$54,$44,$34,$24,$14,$04
	DC.B $F4,$E4,$D4,$C4,$B4,$A4,$94
	DC.B $76,$66,$56,$46,$36,$26,$16,$06
	DC.B $F6,$E6,$D6,$C6,$B6,$A6,$96
	DC.B $78,$68,$58,$48,$38,$28,$18,$08
	DC.B $F8,$E8,$D8,$C8,$B8,$A8,$98
	DC.B $7A,$6A,$5A,$4A,$3A,$2A,$1A,$0A
	DC.B $FA,$EA,$DA,$CA,$BA,$AA,$9A
	DC.B $7C,$6C,$5C,$4C,$3C,$2C,$1C,$0C
	DC.B $FC,$EC,$DC,$CC,$BC,$AC

STARTAB:
	DC.B	TPF0&$FF,TPF0/256,TPF1&$FF,TPF1/256,TPF2&$FF,TPF2/256,$32,$06
*	DC.B	4,0,4,0,0,0,0,0
*	DC.B	0,4,0,0,0,0,0,0
*	DC.B	$78,$68,$67,$48,$33,$28,$18,$08
*	DC.B	$77,$67,$57,$47,$37,$27,$17,$07
*	DC.B	$00,$00,$00,$00,$00,$00,$00,$00
*	DC.B	$00,$00,$00,$00,$00,$00,$00,$00
*	DC.B	5,5,5,5,5,5,5,5
*	DC.B	5,5,5,5,5,5,5,5
*	DC.B	$FF,$FF,$00,$01,$00,$01,$FF,$FF
THOR:
	DC.B	7,16,56,25
	DC.B	70,140,16,35,125,50,38,60
	DC.B	68,35,125,140
TVER:
	DC.B	$80,$80,$FF,$FF
	DC.B	$40,$40,$10,$50,$40,$90,$90,$E0
	DC.B	$70,$80,$90,$A0
TTYP:
	DC.B	$10,$20,$80,$80
	DC.B	$30,$40,$50,$60,$70,$30,$30,$30
	DC.B	$00,$01,$02,$05
TREF:
	DC.B	0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0
UHOR:
	DC.B	7,16,56,25
	DC.B	70,140,16,35,125,50,38,60
	DC.B	68,35,125,140
UVER:
	DC.B	$80,$80,$FF,$FF
	DC.B	$40,$40,$10,$50,$40,$90,$90,$E0
	DC.B	$70,$80,$90,$A0
UTYP:
	DC.B	$10,$20,$80,$80
	DC.B	$30,$40,$50,$60,$70,$30,$30,$30
	DC.B	$00,$01,$02,$05
UREF:
	DC.B	0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0
VHOR:
	DC.B	7,16,56,25
	DC.B	70,140,16,35,125,50,38,60
	DC.B	68,35,125,140
VVER:
	DC.B	$80,$80,$FF,$FF
	DC.B	$40,$40,$10,$50,$40,$90,$90,$E0
	DC.B	$70,$80,$90,$A0
VTYP:
	DC.B	$10,$20,$80,$80
	DC.B	$30,$40,$50,$60,$70,$30,$30,$30
	DC.B	$00,$01,$02,$05
VREF:
	DC.B	0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0
	
	.ORG	$FF70
SCORLO:
	DC.B	$00,$00
SCORHI:
	DC.B	$00,$00
KEYS:
	DC.B	$00,$00
IT:
	DC.B	$00
LINETAB:
	DS.B	8
LINE1TAB:
	DS.B	8
PLAYTAB:
	DS.B	16
ENEMHOR:
	DC.B	7,16,56,25
	DC.B	70,140,16,35,125,50,38,60
	DC.B	68,35,125,140
ENEMVER:
	DC.B	$80,$80,$FF,$FF
	DC.B	$40,$40,$10,$50,$40,$90,$90,$E0
	DC.B	$70,$80,$90,$A0
ENEMTYP:
	DC.B	$10,$20,$80,$80
	DC.B	$30,$40,$50,$60,$70,$30,$30,$30
	DC.B	$00,$01,$02,$05
ENEMREF:
	DC.B	0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0
DIR:
	DC.B	$00,$00,$00,$00
	DC.B	$00,$00,$00,$00,$00,$00,$00,$00
